library(Seurat)

L1  <-  Read10X(data.dir = './raw_data/L236-A/')
L2  <-  Read10X(data.dir = './raw_data/L236-B/')
L3  <-  Read10X(data.dir = './raw_data/L236-C/')
L4  <-  Read10X(data.dir = './raw_data/L236-D/')


umis <- L1$`Gene Expression`
htos <- L1$`Antibody Capture`
joint.bcs <- intersect(colnames(umis), colnames(htos))

# Subset RNA and HTO counts by joint cell barcodes
umis <- umis[, joint.bcs]
htos <- as.matrix(htos[, joint.bcs])
htos <- htos[c("HTO_AHH01_TotalSeqA","HTO_AHH02_TotalSeqA"),]
# Confirm that the HTO have the correct names
rownames(htos)

L1_exp <- CreateSeuratObject(counts = L1$`Gene Expression`,project = 'L236-A',min.cells = 0,min.features = 0)
L1_exp <- NormalizeData(L1_exp)
# Find and scale variable features
L1_exp <- FindVariableFeatures(L1_exp, selection.method = "mean.var.plot")
L1_exp <- ScaleData(L1_exp, features = VariableFeatures(L1_exp))
L1_exp[["HTO"]] <- CreateAssayObject(counts = htos)
L1_exp <- NormalizeData(L1_exp, assay = "HTO", normalization.method = "CLR")

L1_exp <- HTODemux(L1_exp, assay = "HTO", positive.quantile = 0.8)
#Idents(L1_exp) <- "HTO_maxID"
RidgePlot(L1_exp, assay = "HTO", features = rownames(L1_exp[["HTO"]]), ncol = 2,)

### L2
umis <- L2$`Gene Expression`
htos <- L2$`Antibody Capture`
joint.bcs <- intersect(colnames(umis), colnames(htos))

# Subset RNA and HTO counts by joint cell barcodes
umis <- umis[, joint.bcs]
htos <- as.matrix(htos[, joint.bcs])
htos <- htos[c("HTO_AHH01_TotalSeqA","HTO_AHH02_TotalSeqA"),]
# Confirm that the HTO have the correct names
rownames(htos)

L2_exp <- CreateSeuratObject(counts = L2$`Gene Expression`,project = 'L236-B',min.cells = 0,min.features = 0)
L2_exp <- NormalizeData(L2_exp)
# Find and scale variable features
L2_exp <- FindVariableFeatures(L2_exp, selection.method = "mean.var.plot")
L2_exp <- ScaleData(L2_exp, features = VariableFeatures(L2_exp))
L2_exp[["HTO"]] <- CreateAssayObject(counts = htos)
L2_exp <- NormalizeData(L2_exp, assay = "HTO", normalization.method = "CLR")

L2_exp <- HTODemux(L2_exp, assay = "HTO", positive.quantile = 0.8)
#Idents(L2_exp) <- "HTO_maxID"
RidgePlot(L2_exp, assay = "HTO", features = rownames(L2_exp[["HTO"]]), ncol = 2)


### L3
umis <- L3$`Gene Expression`
htos <- L3$`Antibody Capture`
joint.bcs <- intersect(colnames(umis), colnames(htos))

# Subset RNA and HTO counts by joint cell barcodes
umis <- umis[, joint.bcs]
htos <- as.matrix(htos[, joint.bcs])
#htos <- htos[c("HTO_AHH01_TotalSeqA","HTO_AHH02_TotalSeqA"),]
# Confirm that the HTO have the correct names
rownames(htos)

L3_exp <- CreateSeuratObject(counts = L3$`Gene Expression`,project = 'L236-C',min.cells = 0,min.features = 0)
L3_exp <- NormalizeData(L3_exp)
# Find and scale variable features
L3_exp <- FindVariableFeatures(L3_exp, selection.method = "mean.var.plot")
L3_exp <- ScaleData(L3_exp, features = VariableFeatures(L3_exp))
L3_exp[["HTO"]] <- CreateAssayObject(counts = htos)
L3_exp <- NormalizeData(L3_exp, assay = "HTO", normalization.method = "CLR")

L3_exp <- HTODemux(L3_exp, assay = "HTO", positive.quantile = 0.8)
#Idents(L3_exp) <- "HTO_maxID"
RidgePlot(L3_exp, assay = "HTO", features = rownames(L3_exp[["HTO"]]), ncol = 2)


### L4
umis <- L4$`Gene Expression`
htos <- L4$`Antibody Capture`
joint.bcs <- intersect(colnames(umis), colnames(htos))

# Subset RNA and HTO counts by joint cell barcodes
umis <- umis[, joint.bcs]
htos <- as.matrix(htos[, joint.bcs])
htos <- htos[c("HTO_AHH03_TotalSeqA","HTO_AHH04_TotalSeqA"),]
# Confirm that the HTO have the correct names
rownames(htos)

L4_exp <- CreateSeuratObject(counts = L4$`Gene Expression`,project = 'L236-D',min.cells = 0,min.features = 0)
L4_exp <- NormalizeData(L4_exp)
# Find and scale variable features
L4_exp <- FindVariableFeatures(L4_exp, selection.method = "mean.var.plot")
L4_exp <- ScaleData(L4_exp, features = VariableFeatures(L4_exp))
L4_exp[["HTO"]] <- CreateAssayObject(counts = htos)
L4_exp <- NormalizeData(L4_exp, assay = "HTO", normalization.method = "CLR")

L4_exp <- HTODemux(L4_exp, assay = "HTO", positive.quantile = 0.8)
#Idents(L4_exp) <- "HTO_maxID"
RidgePlot(L4_exp, assay = "HTO", features = rownames(L4_exp[["HTO"]]), ncol = 2)

#### merge data
mrege_data<-c(L2_exp,L3_exp,L4_exp)
cell.ids<-c('L236-A','L236-B','L236-C','L236-D')
L236<-merge(L1_exp,y=mrege_data,add.cell.ids = cell.ids, project = "L236")

# First, we will remove negative cells from the object
L236 <- subset(L236, idents = "Negative", invert = TRUE)
L236 <- subset(L236, idents = "Doublet", invert = TRUE)

saveRDS(L236,'L236.demuxlet.new.rds')
L236 <- readRDS('L236.demuxlet.new.rds')
# Add other info
L236@meta.data$Age <- NA
L236@meta.data$Diet <- NA
L236@meta.data$Tissue <- NA
L236@meta.data[(L236@meta.data$orig.ident=='L236-A'),]$Age <- 'Young'
L236@meta.data[(L236@meta.data$orig.ident=='L236-B')|(L236@meta.data$orig.ident=='L236-D'),]$Age <- 'Adult'
L236@meta.data[(L236@meta.data$orig.ident=='L236-C'),]$Age <- 'Aged'

L236@meta.data[(L236@meta.data$hash.ID=='HTO-AHH01-TotalSeqA')|(L236@meta.data$hash.ID=='HTO-AHH03-TotalSeqA'),]$Tissue <- 'Calvarial Periosteum'
L236@meta.data[(L236@meta.data$hash.ID=='HTO-AHH02-TotalSeqA')|(L236@meta.data$hash.ID=='HTO-AHH04-TotalSeqA'),]$Tissue <- 'Sagittal Suture Mesenchyme'

L236@meta.data[(L236@meta.data$hash.ID=='HTO-AHH03-TotalSeqA')|(L236@meta.data$hash.ID=='HTO-AHH04-TotalSeqA'),]$Diet <- 'Ad libitum'
L236@meta.data[(L236@meta.data$hash.ID=='HTO-AHH02-TotalSeqA'),]$Diet <- 'Intermittent Fasting'
L236@meta.data[(L236@meta.data$hash.ID=='HTO-AHH01-TotalSeqA'),]$Diet <- 'Intermittent Fasting'
L236@meta.data[(L236@meta.data$orig.ident=='L236-A'),]$Diet <- 'Ad libitum'

# Calculate a tSNE embedding of the HTO data
DefaultAssay(L236) <- "RNA"
L236[["percent.mt"]] <- PercentageFeatureSet(L236,pattern = "mt-")
fivenum(L236$percent.mt)
p1 <- VlnPlot(object = L236, features = c("nFeature_RNA", "nCount_RNA", "percent.mt",'percent.rb'), ncol = 3, pt.size = 0,group.by = 'orig.ident') 
p1
p1 <- VlnPlot(object = L236, features = c("nFeature_RNA", "nCount_RNA", "percent.mt",'percent.rb'), ncol = 3, pt.size = 0,group.by = 'hash.ID')
p1
L236 <- subset(L236, subset = nFeature_RNA > 500 & nFeature_RNA < 5000 & percent.mt <5)
L236 <- NormalizeData(L236,normalization.method = "LogNormalize", scale.factor = 10000)
L236 <- FindVariableFeatures(L236,selection.method = "vst", nfeatures = 2000)
all.genes <- rownames(L236)
L236 <- ScaleData(L236,features = all.genes)
saveRDS(L236,'L236.scale.rds')

L236 <- RunPCA(L236, features =VariableFeatures(object = L236))
#check PCA result
print(L236[["pca"]], dims = 1:20,nfeatures = 3)

#PCA scatter；
DimPlot(L236, reduction = "pca")+NoLegend()
#PCA heatmap；
DimHeatmap(L236, dims = 1:20, cells = 2000,balanced = TRUE)




### divide into 2 tissue
CP <- subset(L236,subset=Tissue=='Calvarial Periosteum')
SSM <- subset(L236,subset=Tissue=='Sagittal Suture Mesenchyme')

################ CP
CP <- NormalizeData(CP,normalization.method = "LogNormalize", scale.factor = 10000)
CP <- FindVariableFeatures(CP,selection.method = "vst", nfeatures = 2000)
all.genes <- rownames(CP)
CP <- ScaleData(CP,features = all.genes)

CP <- RunPCA(CP, features =VariableFeatures(object = CP))
#check PCA result
print(CP[["pca"]], dims = 1:20,nfeatures = 3)

#PCA scatter；
DimPlot(CP, reduction = "pca")+NoLegend()
#PCA heatmap；
DimHeatmap(CP, dims = 1:20, cells = 2000,balanced = TRUE)

ElbowPlot(CP)
library(pheatmap)

### check different markers
genes =c("Lepr","Prrx1","Cd200","Thy1","Ctsk","Acta2","Gli1","Mcam")
genes =c("Lepr","Prrx1","Cd200","Thy1","Ctsk","Acta2","Gli1","Mcam","Alpl","Mme","Slc44a1","Ror2","Spp1","Bglap","Sp7","Ibsp") #stem cell marker
genes =c( 'Pecam1', 'Emcn', 'Cd34')## Endo makrer
genes =c("Wipi1","Mlx","42795","Gdi1","Zdhhc6","Stam","Prag1","Coro1a",  "Arg1","Mgl2","Tmem26","Rnase2a","Mrc1","Egr2","Flt1","Chil3") ### M1 & M2
genes=c('Cxcr4','Itga4','Flt1','Il1b', 'Il6','Tnf','Arg1', 'Il10','Chil3','Mmp9')  ##Pro-angiogenic neutrophils markers


dir.create('CP/cluster')
for (dim  in c(5:20)) {
  for (res in c(0.4,0.5,0.6,0.7,0.8,0.9,1.0)) {
    #find clusters
    CP <- FindNeighbors(CP, dims = 1:dim)
    CP <- FindClusters(CP, resolution = res)
    #  heatmap showing clusters with marker genes
    mycounts <- as.data.frame(AverageExpression(CP,slot = 'scale.data')$RNA,)
    group_list<-c(colnames(mycounts))
    col<-data.frame(Type=group_list)
    col$Type<-factor(col$Type,levels = c(colnames(mycounts)))
    rownames(col)<-colnames(mycounts)
    bks <- seq(-2.1, 2.1, by = 0.1)
    a<-colorRampPalette(c("blue", "white","red"))(length(bks)-1)
    p<-pheatmap(mycounts[ rownames(mycounts)%in% genes,],cluster_row = T,cluster_col=T,show_colnames =T,show_rownames=T,
                annotation_legend=T,annotation_col = col,scale = 'none',color = a,breaks = bks)
    p
    ggsave(paste0('CP/cluster/',dim,'_',res,'.png'),p)
  }
}



### use the code above to repeat SSM clusters and heatmap

# Use the code below for DEGs
getwd()
setwd("/Users/k1773283/OneDrive - King's College London/RNAseq analysis - Manuscript/JR scRNAseq/Periosteum")
periosteum <- readRDS(file = "CP.rds")

# Check which metadata Yin's CP.rds object already has
periosteum@meta.data
library(Seurat)
DimPlot(periosteum, reduction = "umap", group.by = "seurat_clusters", label = T)
head(periosteum@meta.data)
FeaturePlot(periosteum, features = c("Ptprc","Prrx1"), pt.size = 0.2) + DimPlot(periosteum, reduction = "umap", group.by = "seurat_clusters", label = T)


# Add combined metadata for easy filtering between samples
periosteum$Age_Diet <- paste(periosteum$Age, periosteum$Diet, sep = "_")
periosteum$Cluster_Age_Diet <- paste(periosteum$seurat_clusters, periosteum$Age_Diet, sep = "_")
periosteum$Cluster_Age_Diet
Idents(periosteum) <- periosteum$Cluster_Age_Diet

# Find DEGs regardless of condition between 0 and 1
Idents(periosteum) <- periosteum$seurat_clusters
FindMarkers(periosteum, ident.1 = "0", ident.2 = "1", verbose = TRUE)

# Are these DEGs the same in just Young?
Idents(periosteum) <- periosteum$Cluster_Age_Diet
FindMarkers(periosteum, ident.1 = "0_Aged_Intermittent Fasting", ident.2 = "0_Aged_Ad libitum", verbose = TRUE)

# DEGs in Aged between diets
Idents(periosteum) <- periosteum$Age_Diet
FindMarkers(periosteum, ident.1 = "Aged_Intermittent Fasting", ident.2 = "Aged_Ad libitum", verbose = TRUE)

Idents(periosteum) <- periosteum$seurat_clusters
levels(periosteum)
periosteum <- RenameIdents(object = periosteum, `0` = "Prrx1", `1` = "Prrx1",`2` = "CD45", `3` = "Osteo",`4` = "Endo",`5` = "CD45",`6` = "CD45",`7` = "CD45",`8` = "CD45",`9` = "Fibro",`10` = "CD45",`11` = "Osteo",`12` = "CD45",`13` = "Osteo")
periosteum$Type <- Idents(periosteum)
periosteum$Type_Age_Diet <- paste(periosteum$Type, periosteum$Age_Diet, sep = "_")

# DEGs in Prrx1_Aged between diets
Idents(periosteum) <- periosteum$Type_Age_Diet
Prrx1_Aged.IFvsAL <- FindMarkers(periosteum, ident.1 = "Prrx1_Aged_Intermittent Fasting", ident.2 = "Prrx1_Aged_Ad libitum", verbose = TRUE)
library(openxlsx)
write.xlsx(Prrx1_Aged.IFvsAL, "Prrx1_Aged.IFvsAL.xlsx",sheetName="Data", colNames=T,rowNames=T,showNA = F, Append = TRUE)
Prrx1_Aged.IFvsAL$Genes <- rownames(Prrx1_Aged.IFvsAL)

# DEGs in Prrx1_Adult between diets
Idents(periosteum) <- periosteum$Type_Age_Diet
Prrx1_Adult.IFvsAL <- FindMarkers(periosteum, ident.1 = "Prrx1_Adult_Intermittent Fasting", ident.2 = "Prrx1_Adult_Ad libitum", verbose = TRUE)
Prrx1_Adult.IFvsAL$Genes <- rownames(Prrx1_Adult.IFvsAL)

# DEGs in Prrx1 between Adult AL and Aged AL
Idents(periosteum) <- periosteum$Type_Age_Diet
Prrx1.AdultvsAged <- FindMarkers(periosteum, ident.1 = "Prrx1_Adult_Ad libitum", ident.2 = "Prrx1_Aged_Ad libitum", verbose = TRUE)
Prrx1.AdultvsAged$Genes <- rownames(Prrx1.AdultvsAged)

FeaturePlot(periosteum, features = c("Dbp","Tef","Hlf"), split.by = "Age_Diet", pt.size = 0.2)
periosteum$Age_Diet <- factor(periosteum$Age_Diet, levels = c("Young_Ad libitum","Adult_Ad libitum","Adult_Intermittent Fasting","Aged_Ad libitum","Aged_Intermittent Fasting"))

# Save the object with new metadata
saveRDS(periosteum, "CP_JR")
